package com.digiwin.athena.semc.entity.portal;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.digiwin.athena.semc.entity.base.BaseEntity;
import lombok.Data;

import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * 预设组件表实体
 */
@Data
@TableName(value = "t_label_system_pre")
public class LabelSystemPre extends BaseEntity<LabelSystemPre> implements Serializable {

    /**
     * 主键id
     */
    @TableId(type = IdType.AUTO)
    private Long id;

    /**
     * 客户端类型 PC端：0，移动端：1
     * ClientTypeTypeEnum
     */
    @TableField(value = "client_type")
    private Integer clientType;

    /**
     * 预设组件名称
     */
    @TableField(value="name")
    private String name;

    /**
     * 预设组件名称-繁体
     */
    @TableField(value="name_tw")
    private String nameTw;

    /**
     * 组件分类
     * pc端（ 0-预设组件-三方待办、1-预设组件-三方报表、2-预设组件-新闻公告、5-预设组件-固定组件、6-自定义组件-统计）
     * 移动端（ 0-预设组件-金刚区、1-预设组件-任务组件、2-预设组件-项目追踪组件、4：轮播图、5：公告、6：标题、7：分割线、8：三方待办、9：图片、10：业务入口）
     */
    @TableField(value="data_category")
    private Integer dataCategory;

    /**
     * 数据类型（0：待办、1：三方报表、2：新闻公告、3：邮件、4：常用、5：收藏、6：全局资讯、7：绩效、8：作业工作台、9：行事历）
     */
    @TableField(value="data_type")
    private Integer dataType;

    /**
     * 有效状态 0:无效 1:有效
     */
    @TableField(value="valid_status")
    private Integer validStatus;

    /**
     * 是否需要卡死状态为有效（0：不需要；1：需要）
     */
    @TableField(value="is_enable_true")
    private Integer isEnableTrue;

    /**
     * 是否需要选择数据源（0：不需要；1：需要）
     */
    @TableField(value="is_use_data")
    private Integer isUseData;


    /**
     * 租户id
     */
    @TableField(value="tenant_id")
    private String tenantId;


    /**
     * 创建者登录名称
     */
    @TableField(value="create_user_name")
    protected String createUserName;

    /**
     * 更新者登录名称
     */
    @TableField(value="modify_user_name")
    protected String modifyUserName;

}