package com.digiwin.athena.semc.entity.portal;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.digiwin.athena.semc.entity.base.BaseEntity;
import lombok.Data;

import java.io.Serializable;

/**
 * 组件数据源关系表实体
 */
@Data
@TableName(value = "t_label_system_source")
public class LabelSystemSource extends BaseEntity<LabelSystemSource> implements Serializable {

    /**
     * 主键id
     */
    @TableId(type = IdType.AUTO)
    private Long id;

    /**
     * 数据源ID
     */
    @TableField(value="data_id")
    private Long dataId;

    /**
     * 组件ID
     */
    @TableField(value="system_id")
    private Long systemId;

    /**
     * 组件来源（ 0：自定义组件、1：预设组件）
     */
    @TableField(value="component_source")
    private Integer componentSource;

    /**
     * 租户id
     */
    @TableField(value="tenant_id")
    private String tenantId;

}