package com.digiwin.athena.semc.entity.portal;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.digiwin.athena.semc.entity.base.BaseEntity;
import lombok.Data;

import java.io.Serializable;

/**
 * 首页logo实体类
 */
@Data
@TableName(value="t_homepage_logo")
public class Logo extends BaseEntity<Logo> implements Serializable {
    /**
     * 主键id
     */
    @TableId(type = IdType.AUTO)
    private Long id;

    /**
     * 图片url,简体
     */
    private String picUrl;

    /**
     * 图片url,繁体
     */
    private String picUrlTw;

    /**
     * 图片url,英文
     */
    private String picUrlUs;

    /**
     * 租户id
     */
    private String tenantId;

    /**
     * 场景标识,0:登录页logo 1:登录后首页logo；
     * 2：首页网页标题logo（登录后）；3：企业标识logo（登录后）；
     * 4：企业标识logo（登录前）；5：网页标题logo（登录前）
     */
    private Integer sceneFlag;

    /**
     * 官网地址-简体
     */
    private String webSiteAddr;

    /**
     * 官网地址,繁体
     */
    private String webSiteAddrTw;

    /**
     * 官网地址,英文
     */
    private String webSiteAddrUs;

    /**
     * 简体网页标题
     */
    private String title;

    /**
     * 繁体 网页标题
     */
    private String titleTw;

    /**
     * 渠道（平台：platform、地端用户：ground）
     */
    private String channel;

    /**
     * 英文 网页标题
     */
    private String titleUs;



    /**
     * 简体 启用点击logo跳转官网状态（0：未启用；1：启用）
     */
    private Integer jumpStatus;


    /**
     * 繁体启用点击logo跳转官网状态（0：未启用；1：启用）
     */
    private Integer jumpStatusTw;


    /**
     * 英文 启用点击logo跳转官网状态（0：未启用；1：启用）
     */
    private Integer jumpStatusUs;



    /**
     * 语言 0:简体 1:繁体 2:英文
     */
    private Integer language;

}