package com.digiwin.athena.semc.entity.portal;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;

import javax.validation.constraints.Size;
import java.io.Serializable;
import java.util.Date;

/**
 * 新闻公告(News)实体类
 *
 * @author sunyfa
 * @since 2022-12-06 13:38:38
 */
@Data
@TableName(value = "t_news")
public class News implements Serializable {
    private static final long serialVersionUID = -62571786083120304L;
    /**
     * 主键
     */
    @TableId(value = "ID", type = IdType.AUTO)
    private Long id;

    /**
     * 系统名称:系统内填入SEMC，系统外填入系统名称
     */
    @TableField(value = "app_name")
    private String appName;

    /**
     * 来源 1代表内部 2代表外部
     */
    @TableField(value = "news_source")
    private Integer newsSource;

    /**
     * 标题
     */
    @TableField(value = "news_title")
    private String newsTitle;

    /**
     * 外部系统公司新闻唯一标识
     */
    @TableField(value = "external_news_id")
    private String externalNewsId;

    /**
     * 新闻URL
     */
    @TableField(value = "news_url")
    private String newsUrl;

    /**
     * 发布者
     */
    @TableField(value = "publisher_name")
    private String publisherName;

    /**
     * 发布时间
     */
    @TableField(value = "publish_time")
    private Date publishTime;

    /**
     * 新闻接收人
     */
    @TableField(value = "news_user")
    private String newsUser;

    /**
     * 租户ID
     */
    @TableField(value = "tenant_id")
    private String tenantId;


    /**
     * 是否已读 0 未读 1 已读
     */
    @TableField(value = "is_read")
    private Integer isRead;

    @TableField(exist = false)
    private Integer isNew;

    // 地中台系统名称
    @TableField(exist = false)
    private String eaiSysName;

    // 地中台系统UID
    @TableField(exist = false)
    private String eaiSysUid;

    // 系统注册的token
    @TableField(exist = false)
    private String appToken;

}
