package com.digiwin.athena.semc.entity.portal;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.digiwin.athena.semc.entity.base.BaseEntity;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 通知实体类
 *
 * @author sunyfa
 * @since 2022-12-06 13:48:51
 */
@Data
@TableName(value = "t_notice")
public class Notice extends BaseEntity<Notice> implements Serializable {
    private static final long serialVersionUID = 966867023071645835L;

    /**
     * 主键
     */
    @TableId(type = IdType.AUTO)
    private Long id;

    /**
     * 系统名称:系统内填入SEMC，系统外填入系统名称
     */
    @TableField(value = "app_name")
    private String appName;

    /**
     * 外部系统通知唯一标识
     */
    @TableField(value = "external_notice_id")
    private String externalNoticeId;

    /**
     * 来源 1代表内部 2代表外部
     */
    @TableField(value = "notice_source")
    private Integer noticeSource;

    /**
     * 通知标题
     */
    @TableField(value = "notice_title")
    private String noticeTitle;

    /**
     * 通知链接
     */
    @TableField(value = "notice_url")
    private String noticeUrl;

    /**
     * 通知发布人名称
     */
    @TableField(value = "publisher_name")
    private String publisherName;

    /**
     * 通知公布时间
     */
    @TableField(value = "publish_time")
    private Date publishTime;

    /**
     * 被通知人
     */
    @TableField(value = "notice_user")
    private String noticeUser;

    /**
     * 租户ID
     */
    @TableField(value = "tenant_id")
    private String tenantId;


    /**
     * 是否已读 0 未读 1 已读
     */
    @TableField(value = "is_read")
    private Integer isRead;

    @TableField(exist = false)
    private Integer isNew;

    // 地中台系统名称
    @TableField(exist = false)
    private String eaiSysName;

    // 地中台系统UID
    @TableField(exist = false)
    private String eaiSysUid;

    // 系统注册的token
    @TableField(exist = false)
    private String appToken;
}
