package com.digiwin.athena.semc.entity.portal;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.List;

/**
 * <p>功能描述：金刚区</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: PortalContentKingKongDistrict.java
 * @Author: wangjwc
 * @Date: created at 2025/9/17 11:17
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@Builder
public class PortalContentKingKongDistrict implements Serializable {
    /**
     * 是否显示文字（0：隐藏，1：显示）
     * 注意：金刚区的isNameShow代替PortalInfoContent的isNameShow
     */
    private Integer isNameShow;

    /**
     *0：默认，金刚区内容在单页全部展开 1：左右滑动,金刚区内容支持左右滑动  2:折叠展开,金刚区部分内容展示收起，点击则展开
     */
    private Integer interactionType = 0;

    /**
     * 0:默认 租户自定义类型，展示原来的金刚区,1:用户自定义类型
     */
    private Integer customType = 0;

    /**
     * 列数
     */
    private Integer columnNum;

    /**
     * 行数
     */
    private Integer lineNum;

    /**
     * 金刚球信息
     */
    private List<PortalContentKingKongDistrictBall> ballList;
}
