package com.digiwin.athena.semc.entity.portal;

import com.baomidou.mybatisplus.annotation.*;
import com.digiwin.athena.semc.entity.base.BaseEntity;
import lombok.Data;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.List;

/**
 * 用户使用门户统计日表
 */
@Data
@TableName(value = "t_portal_count_day")
public class PortalCountDay extends BaseEntity<PortalCountDay> implements Serializable {

    /**
     * 主键id
     */
    @TableId(type = IdType.AUTO)
    private Long id;

    /**
     * 年月日ymd
     */
    @TableField(value="ymd")
    private Integer ymd;

    /**
     * 门户类型（0：极简门户；1：经典门户）
     */
    @NotNull(message = "the portalType cannot be empty")
    @TableField(value="portal_type")
    private Integer portalType;

    /**
     * 租户id
     */
    @TableField(value="tenant_id")
    private String tenantId;

    /**
     * 租户名称
     */
    @TableField(value="tenant_name")
    private String tenantName;


    /**
     * 创建人姓名
     */
    @TableField(value = "create_user_name")
    private String createUserName;


}