package com.digiwin.athena.semc.entity.portal;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.digiwin.athena.semc.entity.base.BaseEntity;
import lombok.Data;

import java.io.Serializable;

/**
 * 用户使用门户统计月表
 */
@Data
@TableName(value = "t_portal_count_month")
public class PortalCountMonth extends BaseEntity<PortalCountMonth> implements Serializable {

    /**
     * 主键id
     */
    @TableId(type = IdType.AUTO)
    private Long id;

    /**
     * 年
     */
    @TableField(value="data_year")
    private String dataYear;

    /**
     * 月
     */
    @TableField(value="data_month")
    private String dataMonth;

    /**
     * 极简门户统计次数
     */
    @TableField(value="mini_count")
    private Integer miniCount;

    /**
     * 经典门户统计次数
     */
    @TableField(value="class_count")
    private Integer classCount;

    /**
     * 使用的天数
     */
    @TableField(value="day_num")
    private Integer dayNum;

    /**
     * 租户id
     */
    @TableField(value="tenant_id")
    private String tenantId;

    /**
     * 租户名称
     */
    @TableField(value="tenant_name")
    private String tenantName;


    /**
     * 创建人姓名
     */
    @TableField(value = "create_user_name")
    private String createUserName;


}