package com.digiwin.athena.semc.entity.portal;

import com.baomidou.mybatisplus.annotation.*;
import com.digiwin.athena.semc.entity.base.BaseEntity;
import com.digiwin.athena.semc.service.workbench.designer.mongo.MultiLanguageDTO;
import lombok.Data;
import org.hibernate.validator.constraints.Length;
import org.springframework.data.mongodb.core.aggregation.ArrayOperators;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.List;
import java.util.Map;

/**
 * 经典门户信息
 */
@Data
@TableName(value = "t_portal_info")
public class PortalInfo extends BaseEntity<PortalInfo> implements Serializable {

    /**
     * 主键id
     */
    @TableId(type = IdType.AUTO)
    private Long id;

    /**
     * 门户来源，0：租户门户，1：ISV门户
     */
    @TableField(exist = false)
    @NotNull(message = "portalTypeSource cannot be empty")
    private Integer portalTypeSource = 0;

    /**
     * 客户端类型 PC端：0，移动端：1
     * ClientTypeTypeEnum
     */
    @NotNull(message = "clientType cannot be empty")
    @TableField(value = "client_type")
    private Integer clientType;

    /**
     * 门户类型（0：门户布局；1：自定义页面布局）
     */
    @TableField(value = "portal_type")
    private Integer portalType;

    /**
     * 自定义页面标题
     */
    @TableField(value = "title")
    private String title;

    /**
     * 自定义页面背景色
     */
    @TableField(value = "bg_color")
    private String bgColor;

    /**
     * 门户设计时Id
     */
    @TableField(value = "portal_designer_id")
    private Long portalDesignerId;

    /**
     * 工作台应用code
     */
    @TableField(value = "workbench_app_code")
    private String workbenchAppCode;

    /**
     * 上级门户ID
     */
    @TableField(value = "parent_id")
    private Long parentId;

    /**
     * 模版ID
     */
    @TableField(value = "template_id")
    private Long templateId;

    /**
     * 默认标识 0:否 1:是
     */
    @TableField(value = "default_flag")
    private Integer defaultFlag;

    /**
     * 门户名称
     */
    @NotBlank(message = "the name cannot be empty")
    @Length(max = 30, min = 1, message = "the name Within 30 characters in length")
    @TableField(value = "name")
    private String name;

    /**
     * 门户描述
     */
    @TableField(value = "portal_desc")
    @Length(max = 100, min = 0, message = "the desc Within 100 characters in length")
    private String portalDesc;

    /**
     * 菜单来源，0：租户菜单，1：ISV菜单
     */
    @TableField(value = "menu_type_source")
    private Integer menuTypeSource;
    /**
     * 自定义菜单模板id
     */
    @TableField(value = "menu_template_id")
    private Long menuTemplateId;

    /**
     * 是否是通用菜单模板 0:否 1:是
     */
    @TableField(exist = false)
    private Integer menuGeneralFlag = 0;

    /**
     * 布局状态（0：未发布；1：已发布）
     */
    @TableField(value = "status")
    private Integer status;

    /**
     * 布局内容
     */
    @TableField(value = "portal_content")
    private String portalContent;

    /**
     * 缩略图文件id
     */
    @TableField(value = "portal_img_id")
    private String portalImgId;

    /**
     * 租户id
     */
    @TableField(value = "tenant_id", updateStrategy = FieldStrategy.IGNORED)
    private String tenantId;

    /**
     * 创建者登录名称
     */
    @TableField(value = "create_user_name")
    protected String createUserName;

    /**
     * 更新者登录名称
     */
    @TableField(value = "modify_user_name")
    protected String modifyUserName;

    /**
     * 内容集合
     */
    @TableField(exist = false)
    private List<PortalInfoContent> contentList;

    /**
     * 缩略图地址
     */
    @TableField(exist = false)
    private String portalImgUrl;

    /**
     * 0：租户端无权限弹框；1：关联源应用页面；2：布局设计器
     */
    @TableField(exist = false)
    private Integer jumpToPage;


    /**
     * 授权提示语，jumpToPage=0时返回
     */
    @TableField(exist = false)
    private String promptMsg;

    /**
     * 最近选择的门户权限不存在时提示信息，为空说明有权限或者第一次使用
     */
    @TableField(exist = false)
    private String recentlyMsg;

    /**
     * 是否是现有的移动门户 true：是 false：否
     */
    @TableField(exist = false)
    private Boolean oldPortalFlag = Boolean.FALSE;

    /**
     * 是否有更新标签 true：是 false：否
     */
    @TableField(exist = false)
    private Boolean isUpdatedFlag = Boolean.FALSE;

    /**
     * 数据版本，如：1.0、2.0
     */
    @TableField(value = "version")
    private String version;

    /**
     * 编译版本，可选
     */
    @TableField(value = "compile_version")
    private String compileVersion;

    /**
     * 发布来源 ISV TENANT
     */
    @TableField(value = "publish_source")
    private String publishSource;

    /**
     * key只有两个name和remark
     */
    @TableField(value = "lang")
    private Map<String, MultiLanguageDTO> lang;

    /**
     * 0:租户 1:ISV
     */
    @TableField(value = "source")
    private Integer source;

    /**
     * 0 没有变更  1 有改变
     */
    @TableField(value = "changed",exist = false)
    private int changed;

    /**
     * 老门户版本为0 默认门户版本为1
     */
    @TableField(value = "version_default")
    private Integer versionDefault;

}