package com.digiwin.athena.semc.entity.portal;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.digiwin.athena.semc.entity.base.BaseEntity;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * @description: 经典门户权限关系表
 */
@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
@TableName(value = "t_portal_info_auth")
public class PortalInfoAuth extends BaseEntity<PortalInfoAuth> implements Serializable {
    /**
     * 主键
     */
    @TableId(type = IdType.AUTO)
    private Long id;

    /**
     * 客户端类型 PC端：0，移动端：1
     * ClientTypeTypeEnum
     */
    @TableField(value = "client_type")
    private Integer clientType;

    /**
     * 权限对象id
     */
    @TableField(value = "auth_id")
    private Long authId;

    /**
     * 权限对象名称
     */
    @TableField(value = "auth_name")
    private String authName;

    /**
     * 权限类型：1.组织 2.角色 3.用户
     */
    @TableField(value = "auth_type")
    private Integer authType;


    /**
     * 租户id
     */
    @TableField(value="tenant_id")
    private String tenantId;


    /**
     * 门户ID
     */
    @TableField(value="portal_id")
    private Long portalId;

    /**
     * 门户类型来源，0：租户门户，1：ISV门户
     */
    @TableField(value="portal_type_source")
    private Integer portalTypeSource;

}