package com.digiwin.athena.semc.entity.portal;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.digiwin.athena.semc.entity.base.BaseEntity;
import com.digiwin.athena.semc.service.workbench.designer.mongo.MultiLanguageDTO;
import lombok.Data;

import java.io.Serializable;
import java.util.Map;

/**
 * 门户内容表
 */
@Data
@TableName(value = "t_portal_info_content")
public class PortalInfoContent extends BaseEntity<PortalInfoContent> implements Serializable {

    /**
     * 主键id
     */
    @TableId(type = IdType.AUTO)
    private Long id;

    /**
     * 上级ID
     */
    @TableField(value = "parent_id")
    private Long parentId;

    /**
     * 部件类型来源，0：租户部件，1：ISV部件
     */
    @TableField(value = "label_type_source")
    private Integer labelTypeSource;

    /**
     * 门户ID
     */
    @TableField(value = "portal_id")
    private Long portalId;

    /**
     * 组件/菜单ID
     */
    @TableField(value = "content_id")
    private Long contentId;

    /**
     * 组件类型
     * pc端（0：自定义组件、1：预设组件、2：自定义菜单、3：容器）；
     * 移动端：（0-预设组件-金刚区、1-预设组件-任务组件、2-预设组件-项目追踪组件、3-金刚球、4：轮播图、5：公告、6：标题、7：分割线、8：三方待办、9：图片、10：业务入口）
     */
    @TableField(value = "content_type")
    private Integer contentType;

    /**
     * 内容组件名称
     */
    @TableField(value = "content_name")
    private String contentName;


    /**
     * 租户id
     */
    @TableField(value = "tenant_id")
    private String tenantId;

    /**
     * 内容uuid，相同组件uuid不同
     */
    @TableField(value = "content_uuid")
    private String contentUuid;

    /**
     * 是否显示标题（0：否，1：是）
     */
    @TableField(value = "is_name_show")
    private Integer isNameShow;

    /**
     * 数据类型（0：待办、1：三方报表、2：新闻公告、3：邮件、4：常用、5：收藏、6：全局资讯、7：绩效、8：作业工作台、9：行事历）
     */
    @TableField(value = "data_type")
    private Integer dataType;


    /**
     * 组件内容属性值json
     */
    @TableField(value = "content_attr")
    private String contentAttr;

    /**
     * 多语言
     */
    @TableField(value = "lang")
    private Map<String, MultiLanguageDTO> lang;

    /**
     * 经典门户图标
     */
    @TableField(exist = false)
    private String classicsIcon;

    /**
     * 组件分类
     */
    @TableField(exist = false)
    private Integer dataCategory;

    /**
     * 轮播图信息
     */
    @TableField(exist = false)
    private PortalContentCarousel carouselInfo;

    /**
     * 门户名称
     */
    @TableField(exist = false)
    private String name;

    /**
     * 内嵌网页类型组件的跳转链接
     */
    @TableField(exist = false)
    private String webLinkUrl;

    /**
     * 组件内容信息
     * 公告信息:MobilePortalContentNews
     * 轮播图信息:MobilePortalContentCarousel
     * 标题组件信息:MobilePortalTitleInfoReqDTO
     * 分割线信息:MobilePortalDividerInfoReqDTO
     * 图片组件:MobilePortalImageInfoReqDTO
     * 业务入口组件:MobilePortalBusinessInfoReqDTO
     * 金刚区组件：PortalContentKingKongDistrict
     */
    @TableField(exist = false)
    private Object contentConfig;

    @TableField(value = "designer_id")
    private Long designerId;

    @TableField(value="version")
    private String version;

    /**
     * 栏目id
     */
    @TableField(exist = false)
    private Long columnId;

    /**
     * 栏目标题
     */
    @TableField(exist = false)
    private String title;

    /**
     * 是否展示栏目标题
     */
    @TableField(exist = false)
    private Integer isTitleShow;

    /**
     * 工作台应用code
     */
    @TableField(value = "workbench_app_code")
    private String workbenchAppCode;
}