package com.digiwin.athena.semc.entity.portal;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.digiwin.athena.semc.entity.base.BaseEntity;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;

/**
 * @description: 用户选择经典门户记录表
 */
@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
@TableName(value = "t_portal_info_use")
public class PortalInfoUse extends BaseEntity<PortalInfoUse> implements Serializable {
    /**
     * 主键
     */
    @TableId(type = IdType.AUTO)
    private Long id;


    /**
     * 租户id
     */
    @TableField(value = "tenant_id")
    private String tenantId;

    /**
     * 客户端类型 PC端：0，移动端：1
     * ClientTypeTypeEnum
     */
    @TableField(value = "client_type")
    private Integer clientType;
    /**
     * 门户ID
     */
    @TableField(value = "portal_id")
    private Long portalId;

    /**
     * 门户类型来源，0：租户门户，1：ISV门户
     */
    @TableField(value = "portal_type_source")
    private Integer portalTypeSource;

    /**
     * 用户最新选择的移动门户类型（0：旧、1：新门户）
     */
    @TableField(value = "version_default",exist = false)
    private Integer versionDefault;

    /**
     * 门户名称
     */
    @TableField(value = "name",exist = false)
    private String name;

    /**
     * 0 没有改变  1 有改变
     */
    @TableField(exist = false)
    private Integer changed;
}