package com.digiwin.athena.semc.entity.portal;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.digiwin.athena.semc.entity.base.BaseEntity;
import lombok.Data;

import java.io.Serializable;

/**
 * 自定义门户组件表
 */
@Data
@TableName(value = "t_portal_layout_custom")
public class PortalLayoutCustom extends BaseEntity<PortalLayoutCustom> implements Serializable {

    /**
     * 主键id
     */
    @TableId(type = IdType.AUTO)
    private Long id;

    /**
     * 组件id
     */
    @TableField(value="label_id")
    private Long labelId;


    /**
     * 组件展示位置
     */
    @TableField(value="label_index")
    private Integer labelIndex;

    /**
     * 组件类型（0：自定义组件、1：预设组件）
     */
    @TableField(value="label_type")
    private Integer labelType;

    /**
     * 默认标识 0:否 1:是
     */
    @TableField(value="default_flag")
    private Integer defaultFlag;


    /**
     * 租户id
     */
    @TableField(value="tenant_id")
    private String tenantId;
}