package com.digiwin.athena.semc.entity.portal;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.digiwin.athena.semc.entity.base.BaseEntity;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * 门户访问记录表
 *
 * @author sungqz
 * @since 2025-09-18
 */
@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
@TableName(value = "t_portal_visit")
public class PortalVisit implements Serializable {
    /**
     * 主键
     */
    @TableId(type = IdType.AUTO)
    private Long id;

    /**
     * 访问的元素id，如门户Id等
     */
    @TableField(value = "visit_ele_id")
    private Long visitEleId;

    /**
     * 客户端类型 0：PC端 1：移动端
     */
    @TableField(value = "client_type")
    private Integer clientType;

    /**
     * 访问类型，0：访问首页门户 1：访问管理后台门户
     */
    @TableField(value = "visit_type")
    private Integer visitType;

    /**
     * 访问者用户id
     */
    @TableField(value = "user_id")
    private String userId;

    /**
     * 访问者租户id
     */
    @TableField(value = "tenant_id")
    private String tenantId;

    /**
     * 访问时间
     */
    @TableField(value = "visit_time")
    private LocalDateTime visitTime;
}