package com.digiwin.athena.semc.entity.portal;

import com.baomidou.mybatisplus.annotation.TableId;
import lombok.*;

import java.io.Serializable;

/**
 * @Author: sunyfa
 * @CreateTime: 2023/1/29 9:20
 * @Description: 预装应用
 * @Version: 1.0
 */
@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
@ToString
public class PreinstalledApplication implements Serializable {
    private static final long serialVersionUID = -575952559869566130L;

    /**
     * 主键
     */
    @TableId()
    private Long id;

    /**
     * 应用code
     */
    private String applicationCode;

    /**
     * 应用名称
     */
    private String applicationName;

    /**
     * 应用描述
     */
    private String applicationDescription;

    /**
     * 应用类型
     */
    private String applicationType;



    /**
     * 应用类型：1：敏态bs，2:稳态cs
     */
    private Integer systemType;


    /**
     * appToken
     */
    private String appToken;

    /**
     * 应用sid
     */
    private Long appSid;

    /**
     * 应用id
     */
    private String appId;

    /**
     * 应用秘钥
     */
    private String appSecret;

    /**
     * 商品编码
     */
    private String digiGoodsCode;

    /**
     * 产品代号
     */
    private String productCode;

    /**
     * 应用配置
     */
    private String applicationConfig;

    /**
     * 归户模式 0:自动归户 1：手动归户 2：无需归户
     */
    private Integer userBindFlag;

    /**
     * 状态
     */
    private String status;

    private Integer protocolType;

    private String casServerUrl;

    /**
     * 是否需要获取授权码 0:否 1:是
     */
    private Integer needAuthCodeFlag;
}
