package com.digiwin.athena.semc.entity.portal;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.digiwin.athena.semc.configuration.MySqlJsonHandler;
import com.digiwin.athena.semc.entity.base.BaseEntity;
import lombok.*;
import net.sf.json.JSONObject;

import java.io.Serializable;

/**
 * @Author: sunyfa
 * @CreateTime: 2023/1/29 9:30
 * @Description: 预装应用实例
 * @Version: 1.0
 */
@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
@ToString(callSuper = true)
@TableName(autoResultMap = true)
public class PreinstalledApplicationInstance extends BaseEntity<PreinstalledApplicationInstance> implements Serializable {
    private static final long serialVersionUID = 3196643398435299390L;

    /**
     * 主键
     */
    @TableId ()
    private Long id;

    /**
     * 预装应用主键ID
     */
    private Long preinstalledApplicationId;

    /**
     * 应用扩展配置
     */
    @TableField (typeHandler = MySqlJsonHandler.class)
    private JSONObject applicationExtConfig;

    /**
     * 应用sid
     */
    private Long appSid;

    /**
     * 应用id
     */
    private String appId;

    /**
     * 应用秘钥
     */
    private String appSecret;

    /**
     * 归户模式 0:自动归户 1：手动归户 2：无需归户
     */
    private Integer userBindFlag;

    /**
     * 是否显示在友情链接 0:否；1:是
     */
    private Integer linkDisplayFlag;

    /**
     * 状态：0失效；1生效
     */
    private Integer status;

    /**
     * 租户ID
     */
    private String tenantId;

    /**
     * 预装应用名称
     */
    @TableField(exist = false)
    private String preinstalledApplicationName;
}
