package com.digiwin.athena.semc.entity.portal;

import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.digiwin.athena.semc.entity.base.BaseEntity;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDateTime;

@Data
@TableName(value = "workbench_related_app")
public class RelatedApp implements Serializable {
    private static final long serialVersionUID = -1L;

    /**
     * id
     */
    @TableId
    private Integer id;

    /**
     * 工作台应用code
     */
    @TableField(value = "application")
    private String application;

    /**
     * 关联的应用code
     */
    @TableField(value = "related_application")
    private String relatedApplication;

    /**
     * 关联的应用名称
     */
    @TableField(value = "related_application_name")
    private String relatedApplicationName;

    /**
     * 关联的应用定义名称（多语言）
     */
    @TableField(value = "related_application_def_name")
    private String relatedApplicationDefName;

    /**
     * 元素id
     */
    @TableField(value = "ele_id")
    private String eleId;

    /**
     * 元素类型  1:门户
     */
    @TableField(value = "ele_type")
    private Integer eleType;

    /**
     * 数据版本，诸如：1.0，,2.0
     */
    @TableField(value = "version")
    private String version;

    @TableField(value = "designer_id")
    private Long designerId;

    @TableField(value = "source")
    private Integer source;

    /**
     * 创建日期
     */
    @TableField(value="create_time", fill = FieldFill.INSERT)
    protected String createTime;

    /**
     * 更新日期
     */
    @TableField(value="modify_time", fill = FieldFill.INSERT_UPDATE)
    protected String modifyTime;

    /**
     * 创建者登录账号
     */
    @TableField(value="create_user_id", fill = FieldFill.INSERT)
    protected String createUserId;

    /**
     * 更新者登录账号
     */
    @TableField(value="modify_user_id", fill = FieldFill.INSERT_UPDATE)
    protected String modifyUserId;
}
