package com.digiwin.athena.semc.entity.portal;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 报表(Report)实体类
 *
 * @author sunyfa
 * @since 2022-12-06 10:53:04
 */
@Data
@TableName(value="T_REPORT")
public class Report implements Serializable {
    private static final long serialVersionUID = 269528811820266803L;
    /**
     * 主键
     */
    @TableId(type = IdType.AUTO)
    private Long id;

    /**
     * 系统名称:系统内填入SEMC，系统外填入系统名称
     */
    @TableField(value = "SYSTEM_NAME")
    private String systemName;

    /**
     * 来源 1 代表内部 2 代表外部
     */
    @TableField(value = "REPORT_SOURCE")
    private String reportSource;

    /**
     * 报表名称
     */
    @TableField(value = "REPORT_NAME")
    private String reportName;

    /**
     * 报表URL
     */
    @TableField(value = "REPORT_URL")
    private String reportUrl;

    /**
     * 报表所属模块
     */
    @TableField(value = "REPORT_MODULE")
    private String reportModule;

    /**
     * 发布者
     */
    @TableField(value = "PUBLISHER")
    private String publisher;

    /**
     * 发布时间
     */
    @TableField(value = "PUBLISH_TIME")
    private Date publishTime;

    /**
     * 创建人
     */
    @TableField(value = "CREATED_BY")
    private String createdBy;

    /**
     * 创建时间
     */
    @TableField(value = "CREATED_TIME")
    private Date createdTime;

    /**
     * 更新人
     */
    @TableField(value = "UPDATE_BY")
    private String updateBy;

    /**
     * 更新时间
     */
    @TableField(value = "UPDATED_TIME")
    private Date updatedTime;

}
