package com.digiwin.athena.semc.entity.portal;

import com.baomidou.mybatisplus.annotation.*;
import lombok.Data;

import java.io.Serializable;

/**
 * 待办通知记录表
 */
@Data
@TableName(value = "t_sync_todo_record")
public class SyncToDoRecord  implements Serializable {

    /**
     * 主键id
     */
    @TableId(type = IdType.AUTO)
    private Long id;

    /**
     * 应用ID，SSO配置-B/S手工配置或者C/S手工配置中的AppId值
     */
    @TableField(value="app_id")
    private String appId;

    /**
     * 同步类型：0:待办完结通知
     */
    @TableField(value="sync_type")
    private Integer syncType;

    /**
     * 外部待办唯一id
     */
    @TableField(value = "to_do_id")
    private String toDoId;

    /**
     * 入参
     */
    @TableField(value="req_json")
    private String reqJson;


    /**
     * 出参
     */
    @TableField(value="resp_json")
    private String respJson;


    /**
     * 状态（0:成功，1：失败）
     */
    @TableField(value="sync_status")
    private Integer syncStatus;


    /**
     * 备注
     */
    @TableField(value="remark")
    private Integer remark;


    /**
     * 租户id
     */
    @TableField(value="tenant_id")
    private String tenantId;

    /**
     * 接入模式（0：混合云、1：纯云上）
     */
    @TableField(value="data_model")
    private Integer dataModel;

    /**
     * 创建日期
     */
    @TableField(value="create_time", fill = FieldFill.INSERT)
    protected String createTime;
}