package com.digiwin.athena.semc.entity.portal;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.digiwin.athena.semc.entity.base.BaseEntity;
import com.fasterxml.jackson.annotation.JsonIgnore;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;

/**
 * 待办列表(TodoList)实体类
 *
 * @author sunyfa
 * @since 2022-12-06 13:48:51
 */
@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
@TableName(value = "semc_todo_field")
public class TodoField  implements Serializable {

    private static final long serialVersionUID = 7007705555722457L;

    /**
     * 主键
     */
    @TableId(type = IdType.AUTO)
    private Long id;

    /**
     * 应用ID，SSO配置-B/S手工配置或者C/S手工配置中的AppId值
     */
    @TableField(value = "app_id")
    private String appId;


    /**
     * 系统名称:系统内填入SEMC，系统外填入系统名称
     */
    @TableField(value = "app_name")
    @JsonIgnore
    private String appName;

    /**
     * 待办人
     */
    @TableField(value = "to_do_user")
    @JsonIgnore
    private String toDoUser;

    /**
     * 显示名称
     */
    @TableField(value = "display_name")
    private String displayName;

    /**
     * 显示顺序
     */
    @TableField(value = "display_order")
    private Integer displayOrder;

    /**
     * 显示字段绑定数据的字段
     */
    @TableField(value = "binding_data_key")
    private String bindingDataKey;

    /**
     * 创建时间
     */
    @TableField(value = "create_time")
    private String createTime;
}