package com.digiwin.athena.semc.entity.portal;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.digiwin.athena.semc.entity.base.BaseEntity;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 待办列表(TodoList)实体类
 *
 * @author sunyfa
 * @since 2022-12-06 13:48:51
 */
@Data
@TableName(value = "semc_todo")
public class TodoList implements Serializable {
    private static final long serialVersionUID = 966867023071645835L;

    /**
     * 主键
     */
    @TableId(type = IdType.AUTO)
    private Long id;

    /**
     * 应用code，SSO配置-B/S手工配置或者C/S手工配置中的应用id值
     */
    @TableField(value = "app_id_code")
    private String appIdCode;

    /**
     * 应用ID，SSO配置-B/S手工配置或者C/S手工配置中的AppId值
     */
    @TableField(value = "app_id")
    private String appId;


    /**
     * 系统名称:系统内填入SEMC，系统外填入系统名称
     */
    @TableField(value = "app_name")
    private String appName;

    /**
     * 来源 1代表内部 2代表外部
     */
    @TableField(value = "to_do_source")
    @JsonIgnore
    private Integer toDoSource;

    /**
     * 外部系统待办唯一标识
     */
    @TableField(value = "to_do_id")
    private String toDoId;

    /**
     * PC待办跳转URL
     */
    @TableField(value = "to_do_url")
    private String toDoUrl;


    /**
     * APP待办跳转URL
     */
    @TableField(value = "to_do_mobile_url")
    private String mobileUrl;

    /**
     * 待办数据
     */
    @TableField(value = "to_do_data")
    private String toDoData;

    /**
     * 账套id
     */
    @TableField(value = "account_id")
    private String accountId;

    /**
     * 账套名称
     */
    @TableField(value = "account_name")
    private String accountName;

    /**
     * 待办人
     */
    @TableField(value = "to_do_user")
    @JsonIgnore
    private String toDoUser;

    /**
     * 是否已办结 0 待办 1 已办结
     */
    @TableField(value = "is_completed")
    @JsonIgnore
    private Integer isCompleted;

    /**
     * 是否已读 0 未读 1 已读
     */
    @TableField(value = "is_read")
    private Integer isRead;

    /**
     * 租户ID
     */
    @TableField(value = "tenant_id")
    private String tenantId;

    /**
     * 移动显示的主标题
     */
    @TableField(value = "mobile_main_title")
    private String mobileMainTitle;
    /**
     * 移动显示的副标题
     */
    @TableField(value = "mobile_sub_title")
    private String mobileSubTitle;
    /**
     * 移动显示的文本
     */
    @TableField(value = "mobile_label")
    private String mobileLabel;


    /**
     * 每刻报销的提交时间
     */
    @TableField(exist = false)
    private Date submittedAt;

    /**
     * 创建时间
     */
    @TableField(value = "create_time")
    private String createTime;


    /**
     * 待办数量
     */
    @TableField(exist = false)
    private Integer toDoNum;
}
