package com.digiwin.athena.semc.entity.portal;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.digiwin.athena.semc.entity.base.BaseEntity;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;

import java.io.Serializable;

/**
 * 待办已读实体类
 *
 */
@Data
@TableName(value = "semc_todo_read")
public class TodoRead extends BaseEntity<TodoRead> implements Serializable {
    private static final long serialVersionUID = 966867023071645835L;

    /**
     * 主键
     */
    @TableId(type = IdType.AUTO)
    private Long id;

    /**
     * 应用code，SSO配置-B/S手工配置或者C/S手工配置中的应用id
     */
    @TableField(value = "app_id_code")
    private String appIdCode;

    /**
     * 应用ID，SSO配置-B/S手工配置或者C/S手工配置中的AppId值
     */
    @TableField(value = "app_id")
    private String appId;

    /**
     * 外部待办唯一id
     */
    @TableField(value = "to_do_id")
    private String toDoId;

    /**
     * 待办人
     */
    @TableField(value = "to_do_user")
    private String toDoUser;

    /**
     * 账套id
     */
    @TableField(value = "account_id")
    private String accountId;
}
