package com.digiwin.athena.semc.entity.portal;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.digiwin.athena.semc.entity.base.BaseEntity;
import lombok.Data;

import java.io.Serializable;

/**
 * 三方待办刷新频率设置表
 *
 */
@Data
@TableName(value = "semc_todo_refresh_set")
public class TodosRefreshSet extends BaseEntity<TodosRefreshSet> implements Serializable {
    private static final long serialVersionUID = 966867023071645835L;

    /**
     * 主键
     */
    @TableId(type = IdType.AUTO)
    private Long id;

    /**
     * 点击页签刷新频率（秒）
     */
    @TableField(value = "tabs_time")
    private Integer tabsTime;


    /**
     * 点击页签待办详情刷新频率（秒）
     */
    @TableField(value = "todo_detail_time")
    private Integer todoDetailTime;

    /**
     * 开关，默认开启（1：开启、0：关闭）
     */
    @TableField(value = "is_open")
    private Integer isOpen;

    /**
     * 租户ID
     */
    @TableField(value = "tenant_id")
    private String tenantId;

}
