package com.digiwin.athena.semc.entity.portal;

import com.baomidou.mybatisplus.annotation.*;
import com.digiwin.athena.semc.configuration.MySqlJsonHandler;
import com.digiwin.athena.semc.entity.base.BaseEntity;
import lombok.*;

import java.io.Serializable;

/**
 * 三方应用配置实体类
 *
 * @author sunqgz
 * @since 2025-08-11
 */
@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
@TableName(value = "t_tripartite_application_base")
public class TripartiteApplication implements Serializable {

    private static final long serialVersionUID = -6302307309048925903L;

    /**
     * 主键
     */
    @TableId(type = IdType.AUTO)
    private Long id;

    /**
     * 应用code
     */
    private String applicationCode;

    /**
     * 应用名称
     */
    private String applicationName;

    /**
     * 应用描述
     */
    private String applicationDescription;

    /**
     * 应用配置
     */
    @TableField(typeHandler = MySqlJsonHandler.class)
    private String applicationConfig;

    /**
     * 创建者登录账号
     */
    @TableField(value="create_user_id", fill = FieldFill.INSERT)
    protected String createUserId;

    /**
     * 创建日期
     */
    @TableField(value="create_time", fill = FieldFill.INSERT)
    protected String createTime;

    /**
     * 更新者账号
     */
    @TableField(value="modify_user_id", fill = FieldFill.INSERT_UPDATE)
    protected String modifyUserId;

    /**
     * 更新日期
     */
    @TableField(value="modify_time", fill = FieldFill.INSERT_UPDATE)
    protected String modifyTime;

    /**
     * 租户id
     */
    @TableField(value = "tenant_id")
    private String tenantId;
}
