package com.digiwin.athena.semc.entity.sso;

import com.baomidou.mybatisplus.annotation.*;
import com.baomidou.mybatisplus.extension.handlers.JacksonTypeHandler;
import com.digiwin.athena.semc.entity.base.BaseEntity;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;

import java.io.Serializable;
import java.util.Map;

/**
 * @program: codes
 * @description: 描述
 * @author: Tuo
 * @create: 2022-10-28 18:59
 **/
@Data
@TableName(value="t_erp_sso_info", autoResultMap = true)
public class ErpSsoInfo extends BaseEntity<ErpSsoInfo> implements Serializable {

    /**
     * 主键id
     */
    @TableId(type = IdType.AUTO)
    private Long id;

    /**
     * 租户id
     */
    private String tenantId;

    /**
     * 登录方式 0:本地稳态客户端 1:标准sso登录 2:auth2登录
     */
    private Integer loginType;

    /**
     * 应用code
     */
    private String code;

    /**
     * 应用名称
     */
    private String name;

    /**
     * 应用描述
     */
    private String appDesc;

    /**
     * 客户端方式 1:直接指定路径 2:自定义协议头
     */
    private Integer locationType;

    /**
     * 协议头 客户端地址前缀
     */
    private String prefix;

    /**
     * 稳态客户端配置
     */
    @TableField(updateStrategy = FieldStrategy.IGNORED)
    private String clientLocation;

    /**
     * 客户端地址后缀
     */
    @TableField(updateStrategy = FieldStrategy.IGNORED)
    private String suffix;

    /**
     * 是否base64加密 0:否 1:是
     */
    @Schema(title = "是否使用base64加密参数")
    private Integer base64Encode;

    /**
     * appToken
     */
    @Schema(title = "产品在云端的appToken")
    private String appToken;

    /**
     * 回调地址,用于注册appId和appSecret
     */
    private String callBackUrl;

    /**
     * 应用sid
     */
    private Long appSid;

    /**
     * 应用id
     */
    @TableField(updateStrategy = FieldStrategy.NOT_EMPTY)
    private String appId;

    /**
     * 应用秘钥
     */
    @TableField(updateStrategy = FieldStrategy.NOT_EMPTY)
    private String appSecret;

    /**
     * 归户模式 0:自动归户 1：手动归户 2：无需归户
     */
    private Integer userBindFlag;

    /**
     * 有效状态 0:无效 1:有效
     */
    private Integer validStatus;

    /**
     * 协议类型 1、oauth2.0 2、cas
     */
    private Integer protocolType;

    private String casServerUrl;

    /**
     * 返回字段
     */
    @TableField(typeHandler = JacksonTypeHandler.class)
    private Map<String,Object> ext;
}
