package com.digiwin.athena.semc.entity.sso;

import com.baomidou.mybatisplus.annotation.*;
import com.digiwin.athena.semc.entity.base.BaseEntity;
import lombok.*;
import org.hibernate.validator.constraints.Range;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.Size;
import java.io.Serializable;

/**
 * 移动端SSO应用实体类
 *
 * @author sunqgz
 * @since 2024-10-24
 */
@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
@ToString
@TableName(value = "t_mobile_sso_info")
public class MobileSsoInfo extends BaseEntity<MobileSsoInfo> implements Serializable {

    private static final long serialVersionUID = 3656890443429345918L;

    /**
     * 主键id
     */
    @TableId(type = IdType.AUTO)
    private Long id;

    /**
     * 应用code
     */
    @TableField(value = "app_code")
    @NotBlank(message = "应用code不能为空")
    private String appCode;

    /**
     * 应用名称
     */
    @TableField(value = "app_name")
    @NotBlank(message = "应用名称不能为空")
    @Size(min = 1, max = 30, message = "应用名称的长度不能超过30")
    private String appName;

    /**
     * 应用描述
     */
    @TableField(value = "app_desc")
    @Size(max = 200, message = "应用描述的长度不能超过200")
    private String appDesc;

    /**
     * 归户模式 0:自动归户 1：手动归户 2：无需归户 3:外链模式
     */
    @TableField(value = "user_bind_flag")
    @Range(min = 0, max = 3, message = "归户模式不合法")
    private Integer userBindFlag;

    /**
     * 授权回调地址
     */
    @TableField(value = "call_back_url")
    @NotBlank(message = "回调地址不能为空")
    @Size(max = 200, message = "回调地址的长度不能超过200")
    private String callBackUrl;

    /**
     * appToken
     */
    @TableField(value = "app_token")
    private String appToken;

    /**
     * 应用sid
     */
    @TableField(value = "app_sid")
    private Long appSid;

    /**
     * 应用id
     */
    @TableField(value = "app_id", updateStrategy = FieldStrategy.NOT_EMPTY)
    private String appId;

    /**
     * 应用秘钥
     */
    @TableField(value = "app_secret", updateStrategy = FieldStrategy.NOT_EMPTY)
    private String appSecret;

    /**
     * 租户id
     */
    @TableField(value = "tenant_id")
    private String tenantId;

    /**
     * 跳转链接
     */
    @TableField(exist = false)
    private String mobileLinkUrl;
}
