package com.digiwin.athena.semc.entity.sso;

import com.baomidou.mybatisplus.annotation.*;
import com.digiwin.athena.semc.entity.base.BaseEntity;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.Size;
import java.io.Serializable;

/**
 * @description: 第三方web配置表
 * @author: sungq
 * @create: 2022-11-28
 **/
@Data
@TableName(value="t_third_sso_info", autoResultMap = true)
public class ThirdSsoInfo extends BaseEntity<ThirdSsoInfo> implements Serializable {

    /**
     * 主键id
     */
    @TableId(type = IdType.AUTO)
    private Long id;

    /**
     * 应用code
     */
    @TableField(value="app_code")
    @NotBlank(message = "应用code不能为空")
    private String appCode;

    /**
     * 应用名称
     */
    @TableField(value="app_name")
    @NotBlank(message = "应用名称不能为空")
    @Size(min = 1, max = 30, message = "应用名称的长度不能超过30")
    private String appName;

    /**
     * 应用描述
     */
    @TableField(value="app_desc")
    @Size(max = 200, message = "应用描述的长度不能超过200")
    private String appDesc;

    /**
     * 授权回调地址
     */
    @TableField(value="call_back_url")
    @Size(max = 200, message = "回调地址的长度不能超过200")
    private String callBackUrl;

    /**
     * logo回调地址
     */
    @TableField(value="logo_image_url")
    @Size(max = 200, message = "logo回调地址的长度不能超过200")
    private String logoImageUrl;

    /**
     * appToken
     */
    @TableField(value="app_token")
    private String appToken;

    /**
     * 应用sid
     */
    @TableField(value="app_sid")
    private Long appSid;

    /**
     * 应用id
     */
    @TableField(value="app_id", updateStrategy = FieldStrategy.NOT_EMPTY)
    private String appId;

    /**
     * 应用秘钥
     */
    @TableField(value="app_secret", updateStrategy = FieldStrategy.NOT_EMPTY)
    private String appSecret;

    /**
     * 归户模式 0:自动归户 1：手动归户 2：无需归户 3:外链模式
     */
    @TableField(value="user_bind_flag")
    private Integer userBindFlag;

    /**
     * 有效状态 0:无效 1:有效
     */
    @TableField(value="valid_status")
    private Integer validStatus;

    /**
     * 租户id
     */
    @TableField(value="tenant_id")
    private String tenantId;

    /**
     * 扩展字段
     */
    @TableField(value="extend")
    private String extend;

    private Integer protocolType;

    private String casServerUrl;
}
