package com.digiwin.athena.semc.entity.temp;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.digiwin.athena.semc.entity.base.BaseEntity;
import com.digiwin.athena.semc.entity.bench.JobBench;

import java.io.Serializable;
import java.util.List;

import io.github.linpeilie.annotations.AutoMapper;
import lombok.Data;

/**
 * ISV作业工作台模版
 */
@Data
@TableName(value = "t_template_bench")
@AutoMapper(target = JobBench.class)
public class TemplateBench extends BaseEntity<TemplateBench> implements Serializable {

    /**
     * 主键id
     */
    @TableId(type = IdType.AUTO)
    private Long id;

    /**
     * 工作台/泳道名称
     */
    @TableField(value="name")
    private String name;

    /**
     * 上级id
     */
    @TableField(value="parent_id")
    private Long parentId;

    /**
     * 模版ID
     */
    @TableField(value="template_id")
    private Long templateId;

    /**
     * 组件展示位置
     */
    @TableField(value="label_index")
    private Integer labelIndex;

    /**
     * 租户id
     */
    @TableField(value="tenant_id")
    private String tenantId;


    /**
     * 泳道集合
     */
    @TableField(exist = false)
    private List<TemplateBench> laneList;

    /**
     * 自定义组件ID集合
     */
    @TableField(exist = false)
    private List<Long> systemIdList;

    /**
     * 作业集合
     */
    @TableField(exist = false)
    private List<TemplateBenchCustom> jobList;
}