package com.digiwin.athena.semc.entity.temp;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.digiwin.athena.semc.entity.base.BaseEntity;
import com.digiwin.athena.semc.entity.bench.JobBenchCustom;

import java.io.Serializable;

import io.github.linpeilie.annotations.AutoMapper;
import lombok.Data;

/**
 * ISV工作台模版组件关系表
 */
@Data
@TableName(value = "t_template_bench_custom")
@AutoMapper(target = JobBenchCustom.class)
public class TemplateBenchCustom extends BaseEntity<TemplateBenchCustom> implements Serializable {

    /**
     * 主键id
     */
    @TableId(type = IdType.AUTO)
    private Long id;

    /**
     * 工作台ID
     */
    @TableField(value="bench_id")
    private Long benchId;


    /**
     * 自定义组件ID
     */
    @TableField(value="system_id")
    private Long systemId;



    /**
     * 组件展示位置
     */
    @TableField(value="label_index")
    private Integer labelIndex;

    /**
     * 租户id
     */
    @TableField(value="tenant_id")
    private String tenantId;


    /**
     * 自定义组件中文名称
     */
    @TableField(exist = false)
    private String nameZh;

}