package com.digiwin.athena.semc.entity.temp;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * @description: ISV作业工作台模版导入记录表
 */
@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
@TableName(value = "t_template_bench_import")
public class TemplateBenchImport implements Serializable {
    /**
     * 主键
     */
    @TableId(type = IdType.AUTO)
    private Long id;

    /**
     * 文件id
     */
    @TableField(value = "file_id")
    private String fileId;


    /**
     * 成功记录数
     */
    @TableField(value = "success_count")
    private Integer successCount;
    /**
     * 失败记录数
     */
    @TableField(value = "fail_count")
    private Integer failCount;


    /**
     * 创建人姓名
     */
    @TableField(value = "create_user_name")
    private String createUserName;

    /**
     * 租户
     */
    @TableField(value = "tenant_id")
    private String tenantId;


    /**
     * 创建日期
     */
    @TableField(value="create_time")
    protected String createTime;

    /**
     * 更新日期
     */
    @TableField(value="modify_time")
    protected String modifyTime;

    /**
     * 创建者登录账号
     */
    @TableField(value="create_user_id")
    protected String createUserId;

    /**
     * 更新者登录账号
     */
    @TableField(value="modify_user_id")
    protected String modifyUserId;

    /**
     * 删除时间
     */
    @TableField(value="del_time")
    protected LocalDateTime delTime;

    /**
     * 删除标记：0有效；1删除
     */
    @TableField(value="del_flag")
    protected Integer delFlag;

    /**
     * 删除者登录账号
     */
    @TableField(value="del_user_id")
    protected String delUserId;

    /**
     * 文件url
     */
    @TableField(exist = false)
    private String fileUrl;
}