package com.digiwin.athena.semc.entity.temp;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.digiwin.athena.semc.entity.base.BaseEntity;
import com.digiwin.athena.semc.vo.temp.TemplateTenantGroupVO;
import com.digiwin.athena.semc.vo.temp.TemplateTenantVO;
import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * ISV模版配置信息
 */
@Data
@TableName(value = "t_template_info")
public class TemplateInfo extends BaseEntity<TemplateInfo> implements Serializable {

    /**
     * 主键id
     */
    @TableId(type = IdType.AUTO)
    private Long id;

    /**
     * template_type=0时为门户ID
     */
    @TableField(value="content_id")
    private Long contentId;

    /**
     * 默认模版（ 0：否 1：是）
     */
    @TableField(value="default_flag")
    private Integer defaultFlag;

    /**
     * 模版编号
     */
    @TableField(value="template_no")
    private String templateNo;

    /**
     * 模版排序
     */
    @TableField(value="template_sort")
    private Integer templateSort;

    /**
     * 模版名称
     */
    @TableField(value="template_name")
    private String templateName;

    /**
     * 描述
     */
    @TableField(value="template_desc")
    private String templateDesc;

    /**
     * 状态（0：未发布；1：已发布）
     */
    @TableField(value="status")
    private Integer status;

    /**
     * 模版类型（0：经典门户、1：作业工作台、2：自定义菜单）
     */
    @TableField(value="template_type")
    private Integer templateType;

    /**
     * 订阅的类型（0：全部租户、1：部分租户、2：不选择租户）
     */
    @TableField(value="sub_type")
    private Integer subType;

    /**
     * 租户id
     */
    @TableField(value="tenant_id")
    private String tenantId;

    /**
     * 创建者登录名称
     */
    @TableField(value="create_user_name")
    protected String createUserName;

    /**
     * 更新者登录名称
     */
    @TableField(value="modify_user_name")
    protected String modifyUserName;

    /**
     * 0：经典门户、1：作业工作台。默认0
     */
    @TableField(exist = false)
    private int serviceSource;

    /**
     *用户选择需要同步的工作台ID
     */
    @TableField(exist = false)
    private List<Long> benchIdList;

    /**
     *部分租户集合，subType=1时返回
     */
    @TableField(exist = false)
    private List<TemplateTenantVO> subTenantList;

    /**
     *分组集合，subType=1时返回
     */
    @TableField(exist = false)
    private List<TemplateTenantGroupVO> groupList;

    /**
     *模版ID集合
     */
    @TableField(exist = false)
    private List<Long> idList;

}