package com.digiwin.athena.semc.entity.temp;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.digiwin.athena.semc.entity.base.BaseEntity;
import lombok.Data;
import java.io.Serializable;

/**
 * ISV模版配置发布的租户
 */
@Data
@TableName(value = "t_template_info_tenant")
public class TemplateInfoTenant extends BaseEntity<TemplateInfoTenant> implements Serializable {

    /**
     * 主键id
     */
    @TableId(type = IdType.AUTO)
    private Long id;

    /**
     * 模版ID
     */
    @TableField(value="template_id")
    private Long templateId;

    /**
     * 订阅用户ID
     */
    @TableField(value="sub_user_id")
    private String subUserId;

    /**
     * 部门租户选择类型（0：按租户、1：按分组）
     */
    @TableField(value="select_type")
    private Integer selectType;

    /**
     * 订阅的租户id/分组ID
     */
    @TableField(value="group_tenant_id")
    private String groupTenantId;

    /**
     * 订阅的租户名称
     */
    @TableField(value="sub_tenant_name")
    private String subTenantName;

    /**
     * 租户id
     */
    @TableField(value="tenant_id")
    private String tenantId;
}