package com.digiwin.athena.semc.entity.temp;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.digiwin.athena.semc.entity.base.BaseEntity;
import com.digiwin.athena.semc.entity.portal.PortalInfo;

import java.io.Serializable;
import java.util.List;

import io.github.linpeilie.annotations.AutoMapper;
import lombok.Data;

/**
 * ISV经典门户模版信息
 */
@Data
@TableName(value = "t_template_portal_info")
@AutoMapper(target = PortalInfo.class)
public class TemplatePortalInfo extends BaseEntity<TemplatePortalInfo> implements Serializable {

    /**
     * 主键id
     */
    @TableId(type = IdType.AUTO)
    private Long id;

    /**
     * 模版ID
     */
    @TableField(value = "template_id")
    private Long templateId;

    /**
     * 默认标识 0:否 1:是
     */
    @TableField(value = "default_flag")
    private Integer defaultFlag;

    /**
     * 模版/门户名称
     */
    @TableField(value = "name")
    private String name;

    /**
     *  模版/门户描述
     */
    @TableField(value = "portal_desc")
    private String portalDesc;

    /**
     * 自定义菜单模板id
     */
    @TableField(value = "menu_template_id")
    private Long menuTemplateId;

    /**
     * 是否是通用菜单模板 0:否 1:是
     */
    @TableField(exist = false)
    private Integer menuGeneralFlag = 0;

    /**
     * 布局状态（0：未发布；1：已发布）
     */
    @TableField(value = "status")
    private Integer status;

    /**
     * 布局内容
     */
    @TableField(value = "portal_content")
    private String portalContent;

    /**
     * 缩略图文件id
     */
    @TableField(value = "portal_img_id")
    private String portalImgId;


    /**
     * 租户id
     */
    @TableField(value = "tenant_id")
    private String tenantId;

    /**
     * 创建者登录名称
     */
    @TableField(value="create_user_name")
    protected String createUserName;

    /**
     * 更新者登录名称
     */
    @TableField(value="modify_user_name")
    protected String modifyUserName;


    /**
     * 内容集合
     */
    @TableField(exist = false)
    private List<TemplatePortalInfoContent> contentList;

    /**
     * 缩略图地址
     */
    @TableField(exist = false)
    private String portalImgUrl;

    /**
     * 0：租户端无权限弹框；1：关联源应用页面；2：布局设计器
     */
    @TableField(exist = false)
    private Integer jumpToPage;


    /**
     * 授权提示语，jumpToPage=0时返回
     */
    @TableField(exist = false)
    private String promptMsg;


}