package com.digiwin.athena.semc.entity.temp;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.digiwin.athena.semc.entity.base.BaseEntity;
import com.digiwin.athena.semc.entity.portal.PortalInfoContent;
import io.github.linpeilie.annotations.AutoMapper;
import lombok.Data;

import java.io.Serializable;

/**
 * ISV门户模版内容表
 */
@Data
@TableName(value = "t_template_portal_info_content")
@AutoMapper(target = PortalInfoContent.class)
public class TemplatePortalInfoContent extends BaseEntity<TemplatePortalInfoContent> implements Serializable {

    /**
     * 主键id
     */
    @TableId(type = IdType.AUTO)
    private Long id;

    /**
     * 门户ID
     */
    @TableField(value="portal_id")
    private Long portalId;

    /**
     * 组件/菜单ID
     */
    @TableField(value="content_id")
    private Long contentId;

    /**
     * 组件类型（0：自定义组件、1：预设组件、2：自定义菜单、3：容器）
     */
    @TableField(value="content_type")
    private Integer contentType;

    /**
     * 内容组件名称
     */
    @TableField(value="content_name")
    private String contentName;


    /**
     * 租户id
     */
    @TableField(value="tenant_id")
    private String tenantId;

    /**
     * 内容uuid，相同组件uuid不同
     */
    @TableField(value="content_uuid")
    private String contentUuid;

    /**
     * 是否显示标题（0：否，1：是）
     */
    @TableField(value="is_name_show")
    private Integer isNameShow;

    /**
     * 数据类型（0：待办、1：三方报表、2：新闻公告、3：邮件、4：常用、5：收藏、6：全局资讯、7：绩效、8：作业工作台、9：行事历）
     */
    @TableField(value="data_type")
    private Integer dataType;

    /**
     * 经典门户图标
     */
    @TableField(exist = false)
    private String classicsIcon;

    /**
     * 组件分类
     */
    @TableField(exist = false)
    private Integer dataCategory;

}