package com.digiwin.athena.semc.entity.temp;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.digiwin.athena.semc.entity.base.BaseEntity;
import com.digiwin.athena.semc.entity.portal.LabelSystemCustom;

import java.io.Serializable;

import io.github.linpeilie.annotations.AutoMapper;
import lombok.Data;

/**
 * 自定义组件表实体
 */
@Data
@TableName(value = "t_template_system_custom")
@AutoMapper(target = LabelSystemCustom.class)
public class TemplateSystemCustom extends BaseEntity<TemplateSystemCustom> implements Serializable {

    /**
     * 主键id
     */
    @TableId(type = IdType.AUTO)
    private Long id;

    /**
     * 自定义组件名称-中文
     */
    @TableField(value="name_zh")
    private String nameZh;

    /**
     * 自定义组件名称-英文
     */
    @TableField(value="name_us")
    private String nameUs;

    /**
     * 图标
     */
    @TableField(value="icon")
    private String icon;

    /**
     * 经典门户图标
     */
    @TableField(value="classics_icon")
    private String classicsIcon;

    /**
     * 组件分类（ 3-自定义组件-作业集成、4-自定义组件-应用集成、6-自定义组件-统计、7-自定义组件-业务待办）
     */
    @TableField(value="data_category")
    private Integer dataCategory;

    /**
     * 展示方式（ 0：文本列表、1：应用、2：应用作业）
     */
    @TableField(value="show_type")
    private Integer showType;

    /**
     * 有效状态 0:无效 1:有效
     */
    @TableField(value="valid_status")
    private Integer validStatus;

    /**
     * 自定义组件备注
     */
    @TableField(value="remark")
    private String remark;
    /**
     * 租户id
     */
    @TableField(value="tenant_id")
    private String tenantId;


    /**
     * 创建者登录名称
     */
    @TableField(value="create_user_name")
    protected String createUserName;

    /**
     * 更新者登录名称
     */
    @TableField(value="modify_user_name")
    protected String modifyUserName;
}