package com.digiwin.athena.semc.entity.temp;

import com.baomidou.mybatisplus.annotation.*;
import com.digiwin.athena.semc.entity.base.BaseEntity;
import com.digiwin.athena.semc.entity.portal.LabelSystemData;
import io.github.linpeilie.annotations.AutoMapper;
import lombok.Data;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * 数据源表实体
 */
@Data
@TableName(value = "t_template_system_data")
@AutoMapper(target = LabelSystemData.class)
public class TemplateSystemData extends BaseEntity<TemplateSystemData> implements Serializable {

    /**
     * 主键id
     */
    @TableId(type = IdType.AUTO)
    private Long id;

    /**
     * 数据源名称
     */
    @TableField(value="name")
    @NotBlank(message = "the data source name cannot be empty")
    @Length(max = 500, min = 1, message = "长度500个字符以内")
    private String name;

    /**
     * 数据源备注
     */
    @TableField(value="remark")
    @Length(max = 100, min = 0, message = "within 100 characters in length")
    private String remark;

    /**
     * 数据源分类（ 0-预设组件-三方待办、1-预设组件-三方报表、2-预设组件-新闻公告、
     * 3-自定义组件-作业集成、4-自定义组件-应用集成、6-自定义组件-统计、7-自定义组件-业务待办
     */
    @TableField(value="data_category")
    @NotNull(message = "the data source classification cannot be empty")
    private Integer dataCategory;

    /**
     * 源应用数据来源 1:b/s 表 2:c/s 表 3:预设表 4:IAM接口 5:虚拟应用
     */
    @TableField(value="data_type")
    @NotNull(message = "the source application source cannot be empty")
    private Integer dataType;

    /**
     * 应用编码
     */
    @TableField(value="app_code")
    @NotBlank(message = "the source application cannot be empty")
    private String appCode;

    /**
     * 接入模式（0：混合云、1：纯云上）
     */
    @TableField(value="data_model",updateStrategy = FieldStrategy.IGNORED)
    private Integer dataModel;

    /**
     * 作业code
     */
    @TableField(value="work_code",updateStrategy = FieldStrategy.IGNORED)
    private String workCode;

    /**
     * 地中台系统名称
     */
    @TableField(value="middle_system_name",updateStrategy = FieldStrategy.IGNORED)
    @Length(max = 100, min = 0, message = "name should be within 100 characters in length")
    private String middleSystemName;

    /**
     * 地中台系统uid
     */
    @TableField(value="middle_system_uid",updateStrategy = FieldStrategy.IGNORED)
    @Length(max = 100, min = 0, message = "uid should be within 100 characters in length")
    private String middleSystemUid;

    /**
     * 有效状态 0:无效 1:有效
     */
    @TableField(value="valid_status")
    @NotNull(message = "状态不能为空")
    private Integer validStatus;

    /**
     * 三方应用接口地址
     */
    @TableField(value="rest_url",updateStrategy = FieldStrategy.IGNORED)
    @Length(max = 500, min = 0, message = "restUrl should be within 500 characters in length")
    private String restUrl;

    /**
     * 作业回调地址
     */
    @TableField(value="call_back_url",updateStrategy = FieldStrategy.IGNORED)
    @Length(max = 500, min = 0, message = "callBackUrl should be within 500 characters in length")
    private String callBackUrl;


    /**
     * 是否需要自定义作业（0：不需要；1：需要）
     */
    @TableField(value="is_job")
    private Integer isJob;


    /**
     * 租户id
     */
    @TableField(value="tenant_id")
    private String tenantId;


    /**
     * 创建者登录名称
     */
    @TableField(value="create_user_name")
    protected String createUserName;

    /**
     * 更新者登录名称
     */
    @TableField(value="modify_user_name")
    protected String modifyUserName;

    /**
     * 源应用名称
     */
    @TableField(exist = false)
    private String appName;

    /**
     * 作业名称
     */
    @TableField(exist = false)
    private String workName;


    /**
     *应用类型 稳态、敏态
     */
    @TableField(exist = false)
    private String systemType;

    /**
     * SSO配置中的appToken
     */
    @TableField(exist = false)
    private String appToken;


    @TableField(exist = false)
    private Integer protocolType;

    /**
     * 数据来源 1:b/s 表 2:c/s 表 3:预设表应用 4:IAM接口应用 5:虚拟应用
     */
    @TableField(exist = false)
    private Integer dataSource;

    /**
     * SSO配置中的appId
     */
    @TableField(exist = false)
    private String appId;


    /**
     * 是否需要实时获取sso地址，0：不需要；1：需要
     */
    @TableField(exist = false)
    private int isNeedSsoUrl=0;

    /**
     * 是否需要定频刷新，0：不需要；1：需要
     */
    @TableField(exist = false)
    private int isFixedRefresh=0;

    /**
     * 组件id
     */
    @TableField(exist = false)
    private Long systemId;

    /**
     * 统计组件的类型code值
     */
    @TableField(value="count_code")
    private String countCode;

    /**
     * 统计组件的类型的名称code
     */
    @TableField(value="count_content_code")
    private String countContentCode;
	
	    /**
     * 待办数量
     */
    @TableField(exist = false)
    private Integer toDoNum;

}