package com.digiwin.athena.semc.entity.temp;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.digiwin.athena.semc.entity.base.BaseEntity;
import lombok.Data;

import java.io.Serializable;

/**
 * iSV模版预设组件表实体
 */
@Data
@TableName(value = "t_template_system_pre")
public class TemplateSystemPre extends BaseEntity<TemplateSystemPre> implements Serializable {

    /**
     * 主键id
     */
    @TableId(type = IdType.AUTO)
    private Long id;

    /**
     * 预设组件名称
     */
    @TableField(value="name")
    private String name;

    /**
     * 组件分类（ 0-预设组件-三方待办、1-预设组件-三方报表、2-预设组件-新闻公告、5-预设组件-固定组件、6-自定义组件-统计）
     */
    @TableField(value="data_category")
    private Integer dataCategory;

    /**
     * 数据类型（0：待办、1：三方报表、2：新闻公告、3：邮件、4：常用、5：收藏、6：全局资讯、7：绩效、8：作业工作台、9：行事历）
     */
    @TableField(value="data_type")
    private Integer dataType;

    /**
     * 有效状态 0:无效 1:有效
     */
    @TableField(value="valid_status")
    private Integer validStatus;

    /**
     * 是否需要卡死状态为有效（0：不需要；1：需要）
     */
    @TableField(value="is_enable_true")
    private Integer isEnableTrue;

    /**
     * 是否需要选择数据源（0：不需要；1：需要）
     */
    @TableField(value="is_use_data")
    private Integer isUseData;


    /**
     * 租户id
     */
    @TableField(value="tenant_id")
    private String tenantId;


    /**
     * 创建者登录名称
     */
    @TableField(value="create_user_name")
    protected String createUserName;

    /**
     * 更新者登录名称
     */
    @TableField(value="modify_user_name")
    protected String modifyUserName;
}