package com.digiwin.athena.semc.entity.temp;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.digiwin.athena.semc.entity.base.BaseEntity;
import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * 账户分组表
 */
@Data
@TableName(value = "t_template_tenant_group")
public class TemplateTenantGroup extends BaseEntity<TemplateTenantGroup> implements Serializable {

    /**
     * 主键id
     */
    @TableId(type = IdType.AUTO)
    private Long id;

    /**
     * 分组名称
     */
    @TableField(value="name")
    private String name;

    /**
     * 生效状态 0:无效 1:有效
     */
    @TableField(value="valid_status")
    private Integer validStatus;


    /**
     * 订阅用户ID
     */
    @TableField(value="sub_user_id")
    private String subUserId;

    /**
     * 租户id
     */
    @TableField(value="tenant_id")
    private String tenantId;

    /**
     * 创建者登录名称
     */
    @TableField(value="create_user_name")
    protected String createUserName;

    /**
     * 更新者登录名称
     */
    @TableField(value="modify_user_name")
    protected String modifyUserName;


    /**
     * 租户集合
     */
    @TableField(exist = false)
    List<TemplateTenantGroupItem> subTenantList;
}