package com.digiwin.athena.semc.entity.temp;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.digiwin.athena.semc.entity.base.BaseEntity;
import lombok.Data;
import java.io.Serializable;
import java.util.List;

/**
 * 账户和租户关联关系主表
 */
@Data
@TableName(value = "t_template_user_mapping")
public class TemplateUserMapping extends BaseEntity<TemplateUserMapping> implements Serializable {

    /**
     * 主键id
     */
    @TableId(type = IdType.AUTO)
    private Long id;

    /**
     * 应用编码
     */
    @TableField(value="app_code")
    private String appCode;

    /**
     * 订阅用户ID
     */
    @TableField(value="sub_user_id")
    private String subUserId;

    /**
     * 订阅用户名称
     */
    @TableField(value="sub_user_name")
    private String subUserName;

    /**
     * 租户id
     */
    @TableField(value="tenant_id")
    private String tenantId;

    /**
     * 创建者登录名称
     */
    @TableField(value="create_user_name")
    protected String createUserName;

    /**
     * 更新者登录名称
     */
    @TableField(value="modify_user_name")
    protected String modifyUserName;

    /**
     * 订阅的租户集合
     */
    @TableField(exist = false)
    List<TemplateUserTenant> subTenantList;

}