package com.digiwin.athena.semc.entity.temp;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.digiwin.athena.semc.entity.base.BaseEntity;
import lombok.Data;

import java.io.Serializable;

/**
 * 账户关联租户表
 */
@Data
@TableName(value = "t_template_user_tenant")
public class TemplateUserTenant extends BaseEntity<TemplateUserTenant> implements Serializable {

    /**
     * 主键id
     */
    @TableId(type = IdType.AUTO)
    private Long id;

    /**
     * 关联关系ID
     */
    @TableField(value="mapping_id")
    private Long mappingId;


    /**
     * 订阅的租户id
     */
    @TableField(value="sub_tenant_id")
    private String subTenantId;

    /**
     * 订阅的租户名称
     */
    @TableField(value="sub_tenant_name")
    private String subTenantName;

    /**
     * 租户id
     */
    @TableField(value="tenant_id")
    private String tenantId;

    /**
     * 创建者登录名称
     */
    @TableField(value="create_user_name")
    protected String createUserName;

    /**
     * 更新者登录名称
     */
    @TableField(value="modify_user_name")
    protected String modifyUserName;


    /**
     * 订阅用户ID
     */
    @TableField(exist = false)
    private String subUserId;
}