package com.digiwin.athena.semc.entity.tenant;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * 租户参数属性(TenantAttributeDef)实体类
 * @author GUIJF
 */
@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
@TableName(value = "t_tenant_attribute_def")
public class TenantAttributeDef implements Serializable {
    private static final long serialVersionUID = -19210737024096754L;

    /**
     * 主键id
     */
    @TableId(type = IdType.AUTO)
    private Long id;

    /**
     * 创建日期
     */
    @TableField(value = "attribute_name")
    protected String attributeName;

    /**
     * 事件日期
     */
    @TableField(value = "attribute_code")
    protected String attributeCode;

    /**
     * 事件id
     */
    @TableField(value = "data_type")
    private String dataType;

    /**
     * 用户id
     */
    @TableField(value = "is_required")
    private Boolean required;

    /**
     * 默认值
     */
    @TableField(value = "default_value")
    private String defaultValue;

    /**
     * 用户名称
     */
    @TableField(value = "description")
    private String description;

    /**
     * 租户id
     */
    @TableField(value = "sort_order")
    private Integer sortOrder;

    /**
     * 租户名称
     */
    @TableField(value = "create_time")
    private LocalDateTime createTime;

}
