package com.digiwin.athena.semc.entity.tenant;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.digiwin.athena.semc.entity.base.BaseEntity;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.Date;

/**
 * 租户参数值(TenantAttributeValue)实体类
 * @author GUIJF
 */
@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
@TableName(value = "t_tenant_attribute_value")
public class TenantAttributeValue extends BaseEntity<TenantAttributeValue> implements Serializable {
    private static final long serialVersionUID = -19210737024456754L;

    /**
     * 主键id
     */
    @TableId(type = IdType.AUTO)
    private Long id;

    /**
     * 租户ID
     */
    @TableField(value = "tenant_id")
    protected String tenantId;
    /**
     * 属性代号
     */
    @TableField(value = "attribute_id")
    protected Long attributeId;

    /**
     * 数字值
     */
    @TableField(value = "int_value")
    private Integer intValue;

    /**
     * 短字符串值
     */
    @TableField(value = "varchar_value")
    private String varcharValue;

    /**
     * 长文本值
     */
    @TableField(value = "text_value")
    private String textValue;

    /**
     * 时间值
     */
    @TableField(value = "datetime_value")
    private Date datetimeValue;

    /**
     * 小数数字值
     */
    @TableField(value = "decimal_value")
    private Double decimalValue;

    /**
     * 布尔值
     */
    @TableField(value = "boolean_value")
    private Boolean booleanValue;

}
