package com.digiwin.athena.semc.env;

import lombok.Data;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

/**
 * 配置信息
 *
 * @author sungq
 */
@Component
@Data
public class EnvProperties {

    private static final Logger LOGGER = LoggerFactory.getLogger(EnvProperties.class);

    /**
     * 启动环境
     */
    @Value("${spring.profiles.active:dev}")
    private String active;

    /**
     * dap iam
     */
    @Value("${rest-url.iam:}")
    private String iamUri;

    /**
     * dap iam 后台
     */
    @Value("${rest-url.bossIam:}")
    private String bossIamUri;

    /**
     * dap emc
     */
    @Value("${rest-url.emcUrl:}")
    private String emcUrl;

    /**
     * atmc
     */
    @Value("${rest-url.taskmapUrl:}")
    private String taskmapUrl;

    /**
     * audc
     */
    @Value("${rest-url.baseUrl:}")
    private String baseUrl;

    /**
     * 知识中台
     */
    @Value("${rest-url.kbsUri:}")
    private String kbsUri;

    /**
     * 华为测试区（test内）
     */
    @Value("${rest-url.mobileUrl:}")
    private String mobileUrl;

    /**
     * 登录首页地址
     */
    @Value("${rest-url.homePageUrl:}")
    private String homePageUrl;

    /**
     * dmc文档中心
     */
    @Value("${dmc.url:}")
    private String dmcUri;

    /**
     * 用户组件导入的模板id
     */
    @Value("${rest-url.labelFileId:}")
    private String labelFileId;

    /**
     * dap翻译
     */
    @Value("${rest-url.trans:}")
    private String transUri;

    /**
     * 服务云地址
     */
    @Value("${rest-url.esUrl:}")
    private String esUri;

    /**
     * gmc地址
     */
    @Value("${rest-url.gmcUrl:}")
    private String gmcUri;

    /**
     * 授权中心
     */
    @Value("${rest-url.cacUrl:}")
    private String cacUri;

    @Value("${rest-url.fineReportUrl:}")
    private String fineReportUrl;

    @Value("${rest-url.semcUrl:}")
    private String semcUrl;

    @Value("${rest-url.appToken}")
    private String appToken;

    @Value("${esp.espDomain}")
    private String espDomain;

    @Value("${esp.mdcDomain}")
    private String mdcDomain;

    @Value("${esp.kmDomain}")
    private String kmDomain;

    @Value("${esp.eocDomain}")
    private String eocDomain;

    @Value("${esp.athenaAppToken}")
    private String athenaAppToken;

    @Value("${rest-url.semcAppId:}")
    private String semcAppId;

    @Value("${rest-url.appId:}")
    private String appId;

    @Value("${properties.country:}")
    private String country;

    /**
     * appicon域名
     */
    @Value("${rest-url.appIconUrl:}")
    private String appIconUrl;


    /**
     * app定制页域名
     */
    @Value("${rest-url.appCustomizeUrl:}")
    private String appCustomizeUrl;

    /**
     * 绿色智机对应移动ip地址
     */
    @Value("${rest-url.thirdPartySystemId:}")
    private String thirdPartySystemId;

    /**
     * ISV模版用户ID，多个以英文逗号分隔
     */
    @Value("${rest-url.templateUserId:}")
    private String templateUserId;
    /**
     * ISV模版用户ID 所属租户
     */
    @Value("${rest-url.templateTenantId:}")
    private String templateTenantId;

    /**
     * ania
     */
    @Value("${rest-url.aniaUrl:}")
    private String aniaUrl;

    /**
     * athena管理后台Url
     */
    @Value("${rest-url.semcWebUrl:}")
    private String semcWebUrl;

    @Value("${rest-url.aimUrl:}")
    private String aimUrl;

    @Value("${rest-url.appmetadataUrl:}")
    private String appmetadataUrl;

    /**
     * 每刻企业编码
     */
    @Value("${maycur.mayCurEntCode:}")
    private String mayCurEntCode;

    /**
     * 每刻秘钥
     */
    @Value("${maycur.mayCurSecret:}")
    private String mayCurSecret;

    /**
     * 企微应用id
     */
    @Value("${rest-url.weChatAppId:}")
    private String weChatAppId;

    /**
     * 企业微信ID
     */
    @Value("${rest-url.weChatCorpId:}")
    private String weChatCorpId;

}
