package com.digiwin.athena.semc.event.dto;

import com.digiwin.athena.semc.entity.news.NewsAnnouncementAut;
import com.digiwin.athena.semc.proxy.iam.service.model.UserDTO;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.List;
import java.util.Map;

/**
 * 公告发送工作提醒 请求DTO
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
public class SendNoticeDTO {

    /**
     * 公告id
     */
    private Long newsId;

    /**
     * 公告标题
     */
    private String newsTitle;

    /**
     * 全员可见 0:否 1:是
     */
    private Integer allAuthFlag;

    /**
     * 授权组织sid
     */
    private List<Long> orgSidList;

    /**
     * 授权角色sid
     */
    private List<Long> roleSidList;

    /**
     * 授权部门sid
     */
    private List<Long> deptSidList;

    /**
     * 授权用户sid
     */
    private Map<Long, String> userSidMap;

    /**
     * 授权外部用户sid
     */
    private Map<Long, NewsAnnouncementAut> externalUserSidMap;

    /**
     * 授权外部用户
     */
    private List<UserDTO> externalUserList;
}
