package com.digiwin.athena.semc.event.listener;

import com.digiwin.athena.semc.event.EventTrackingEvent;
import com.digiwin.athena.semc.proxywrapper.IamUserService;

import org.springframework.context.ApplicationListener;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Component;

import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;

@Slf4j
@Component
@RequiredArgsConstructor
public class EventTrackingEventListener implements ApplicationListener<EventTrackingEvent> {

    private final IamUserService iamUserService;

    @Override
    @Async("semcAsyncExecutor")
    public void onApplicationEvent(EventTrackingEvent event) {
        // 删除iam用户权限信息sid集合
        iamUserService.removeUserAuthInfo(event.getUserId(), event.getTenantId());
        // 删除是否是超管标识缓存
        iamUserService.removeSuperAdminFlagCache(event.getTenantId(), event.getUserId());
    }
}
