package com.digiwin.athena.semc.event.listener;


import com.digiwin.athena.semc.event.NewsAuthBizIdSetEvent;
import com.digiwin.athena.semc.service.news.NewsAnnouncementAuthService;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.context.ApplicationListener;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Component;

/**
 * 公告权限业务id赋值事件
 */
@Slf4j
@Component
@RequiredArgsConstructor
public class NewsAuthBizIdSetEventListener implements ApplicationListener<NewsAuthBizIdSetEvent> {

    private final NewsAnnouncementAuthService newsAnnouncementAuthService;

    @Override
    @Async("semcAsyncExecutor")
    public void onApplicationEvent(NewsAuthBizIdSetEvent event) {
        log.info("NewsAuthBizIdSetEventListener：{}", event);
        newsAnnouncementAuthService.setNewsAuthBizId(event);
    }
}
