package com.digiwin.athena.semc.event.listener;


import com.digiwin.athena.semc.event.NewsChangeEvent;
import com.digiwin.athena.semc.service.news.NewsAnnouncementTypeService;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.context.ApplicationListener;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Component;

@Slf4j
@Component
@RequiredArgsConstructor
public class NewsChangeEventListener implements ApplicationListener<NewsChangeEvent> {

    private final NewsAnnouncementTypeService newsAnnouncementTypeService;

    @Override
    @Async("semcAsyncExecutor")
    public void onApplicationEvent(NewsChangeEvent event) {
        log.info("NewsChangeEventListener：{}", event);
        newsAnnouncementTypeService.saveNewsCount(event);
    }
}
