package com.digiwin.athena.semc.event.listener;

import com.digiwin.athena.semc.event.SendNoticeEvent;
import com.digiwin.athena.semc.service.news.NewsAnnouncementService;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.context.ApplicationListener;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Component;

/**
 * 公告发送工作提醒 事件
 */
@Slf4j
@Component
@RequiredArgsConstructor
public class SendNoticeEventListener implements ApplicationListener<SendNoticeEvent> {


    private final NewsAnnouncementService newsAnnouncementService;

    @Override
    @Async("semcAsyncExecutor")
    public void onApplicationEvent(SendNoticeEvent event) {
        log.info("SendNoticeEventListener param：{}", event.getSendNoticeDTO());
        newsAnnouncementService.sendNewsNotice(event);
    }
}
