package com.digiwin.athena.semc.event.listener;


import com.digiwin.athena.semc.event.ThirdMessageWecomEvent;
import com.digiwin.athena.semc.service.message.ThirdMessageInfoService;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.context.ApplicationListener;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Component;

@Slf4j
@Component
@RequiredArgsConstructor
public class ThirdMessageWecomEventListener implements ApplicationListener<ThirdMessageWecomEvent> {

    private final ThirdMessageInfoService thirdMessageInfoService;

    @Override
    @Async("semcAsyncExecutor")
    public void onApplicationEvent(ThirdMessageWecomEvent event) {
        log.info("ThirdMessageWecomEventListener：{}", event);
        thirdMessageInfoService.sendWecom(event);
    }
}
