package com.digiwin.athena.semc.mapper.bench;


import com.baomidou.mybatisplus.annotation.InterceptorIgnore;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.digiwin.athena.semc.entity.bench.JobBenchCustom;
import com.digiwin.athena.semc.entity.portal.LabelSystemSource;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 **/
public interface JobBenchCustomMapper extends BaseMapper<JobBenchCustom> {



    /**
     *  保存泳道和组件的关系
     * @param jobBenchCustoms
     */
    Integer insertBatch(@Param("list") List<JobBenchCustom> jobBenchCustoms);

    /**
     *  查询泳道下自定义组件信息
     */
    @InterceptorIgnore(tenantLine = "true")
    List<JobBenchCustom> selectBenchJob(@Param("systemIdList") List<Long> systemIdList,@Param("benchId") Long benchId);


    /**
     *  删除泳道下自定义组件
     */
    List<JobBenchCustom> delBenchJob(@Param("benchIdList") List<Long> benchIdList);


    /**
     * 查询工作台下组件-忽略租户
     * @param benchIdList
     * @return
     */
    @InterceptorIgnore(tenantLine = "true")
    List<JobBenchCustom> selectBenchBy(@Param("benchIdList") List<Long> benchIdList);

    /**
     *  查询泳道下自定义组件
     */
    List<JobBenchCustom> selectBySystem(@Param("systemIdList") List<Long> systemIdList);

}